package com.atlassian.bitbucket.avatar;

import com.atlassian.bitbucket.io.InputSupplier;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;

public interface AvatarSupplier extends InputSupplier<InputStream> {

    /**
     * The content type of the avatar, e.g., "image/png"
     *
     * @return the string representing the content type
     */
    @Nullable
    String getContentType();

    /**
     * Provides an {@code InputStream} to read the avatar. Each call to this method will produce a <i>new</i> stream.
     *
     * @return a stream from the avatar
     * @throws IOException in case the avatar could not be opened or read
     */
    @Nonnull
    @Override
    InputStream open() throws IOException;
}
