package com.atlassian.bitbucket.audit;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;

/**
 * Describes a service for interacting with audit events.
 * @deprecated in 7.0. For removal in 8.0. Use {@link com.atlassian.audit.api.AuditSearchService} instead.
 */
@Deprecated
public interface AuditService {

    /**
     * Retrieves a page of audit events recorded for the specified project.
     *
     * @param project     the project to retrieve events for
     * @param pageRequest describes the page of events to retrieve
     * @return a page of events which may be empty but never {@code null}
     */
    @Nonnull
    Page<MinimalAuditEntry> findByProject(@Nonnull Project project, @Nonnull PageRequest pageRequest);

    /**
     * Retrieves a page of audit events recorded for the specified repository.
     *
     * @param repository  the repository to retrieve events for
     * @param pageRequest describes the page of events to retrieve
     * @return a page of events which may be empty but never {@code null}
     */
    @Nonnull
    Page<MinimalAuditEntry> findByRepository(@Nonnull Repository repository, @Nonnull PageRequest pageRequest);
}
