package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.event.annotation.Auditable;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nullable;

/**
 * Legacy representation of an audited action.
 * <p>
 * {@link AuditEntry} has been replaced by {@link AuditEvent} in 7.0.
 * <p>
 * Instead of auditing an event with {@link Audited}, consumers are recommended to use the replacement
 * {@link Auditable}. Using {@link Audited} means the supplied {@link AuditEntryConverter converter} will only convert
 * the event into an {@link AuditEntry}. The system will internally convert the generated {@link AuditEntry} to an
 * {@link AuditEvent} via a best effort event agnostic conversion before processing the audited event, but this may
 * result in some information loss. Using {@link Auditable} means the supplied {@link AuditEventConverter converter}
 * will convert to an {@link AuditEvent} directly, giving the consumer more control.
 * <p>
 * An {@link AuditEntry} maps to an {@link AuditEvent} as follows:
 * <ul>
 *     <li>
 *         {@link #getAction()} has been replaced by {@link AuditEvent#getActionI18nKey()}
 *     </li>
 *     <li>{@link #getTimestamp()} will not be used anymore and system will assign current time to {@link AuditEvent} </li>
 *     <li>{@link #getUser()} will not be used anymore and system will assign current user in session to {@link AuditEvent} </li>
 *     <li>
 *         {@link #getProject()} and {@link #getRepository()}} have been replaced by
 *         {@link AuditEvent#getAffectedObjects()} (where {@link Project projects} and {@link Repository repositories}
 *         are represented by an {@link AuditResource})
 *     </li>
 *     <li>{@link #getSourceIpAddress()} will not be used anymore and system will assign IP address from current HTTP
 *     session to {@link AuditEvent} </li>
 *     <li>
 *         {@link #getDetails()} and {@link #getTarget()} have no direct replacement, but can be represented as
 *         {@link AuditEvent#getExtraAttribute(String) extra attributes}} (which is what the system will do internally
 *         when converting {@link AuditEntry}s to {@link AuditEvent}s)
 *     </li>
 * </ul>
 *
 * @see AuditEntryBuilder
 * @see AuditEntryConverter
 * @see Audited
 * @deprecated in 7.0 for removal in 8.0. {@link AuditEvent} should be used instead.
 */
@Deprecated
public interface AuditEntry extends MinimalAuditEntry {

    @Nullable
    Project getProject();

    @Nullable
    Repository getRepository();

    @Nullable
    String getSourceIpAddress();

    /**
     * Details of the affected component (e.g. a plugin key or project slug).
     * <p>
     * This method was changed to {@link Nullable} in 7.0 to match implicit existing behaviour. Passing in a
     * {@code target} value when creating an {@link AuditEntry} via {@link AuditEntryBuilder} has never been explicitly
     * required. Consumers of {@link #getTarget()} are advised to add {@code null} handling into their code.
     *
     * @return the target of the audit entry if present, otherwise {@code null}
     */
    @Nullable
    String getTarget();
}
