/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class PullRequestParticipantStatusUpdatedEvent
extends PullRequestEvent {
    private static final Set<PullRequestAction> STATUS_ACTIONS = ImmutableSet.of((Object)((Object)PullRequestAction.APPROVED), (Object)((Object)PullRequestAction.REVIEWED), (Object)((Object)PullRequestAction.UNAPPROVED));
    private final PullRequestParticipant participant;
    private final PullRequestParticipantStatus previousStatus;

    protected PullRequestParticipantStatusUpdatedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull PullRequestAction action, @Nonnull PullRequestParticipant participant, @Nonnull PullRequestParticipantStatus previousStatus) {
        super(source, pullRequest, action);
        Preconditions.checkArgument((boolean)STATUS_ACTIONS.contains((Object)action), (Object)"The action provided must be approval-related");
        this.participant = Objects.requireNonNull(participant, "participant");
        this.previousStatus = Objects.requireNonNull(previousStatus, "previousStatus");
    }

    @Nonnull
    public PullRequestParticipant getParticipant() {
        return this.participant;
    }

    @Nonnull
    public PullRequestParticipantStatus getPreviousStatus() {
        return this.previousStatus;
    }
}

