/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommentUpdateRequest {
    private final long commentId;
    private final CommentSeverity severity;
    private final CommentState state;
    private final String text;
    private final int version;

    private CommentUpdateRequest(@Nonnull Builder builder) {
        this.commentId = builder.commentId;
        this.severity = builder.severity;
        this.state = builder.state;
        this.text = builder.text;
        this.version = builder.version;
    }

    public long getCommentId() {
        return this.commentId;
    }

    @Nullable
    public CommentSeverity getSeverity() {
        return this.severity;
    }

    @Nullable
    public CommentState getState() {
        return this.state;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder {
        private final long commentId;
        private CommentSeverity severity;
        private CommentState state;
        private String text;
        private int version;

        public Builder(long commentId) {
            this.commentId = commentId;
        }

        @Nonnull
        public CommentUpdateRequest build() {
            return new CommentUpdateRequest(this);
        }

        @Nonnull
        public Builder severity(@Nullable CommentSeverity value) {
            this.severity = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nullable CommentState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this;
        }
    }
}

