/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.AbstractPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class SetPullRequestMergeConfigRequest
extends AbstractPullRequestMergeConfigRequest {
    private final String defaultStrategyId;
    private final Set<String> enabledStrategyIds;

    private SetPullRequestMergeConfigRequest(Builder builder) {
        super(builder);
        this.defaultStrategyId = builder.defaultStrategyId;
        this.enabledStrategyIds = builder.enabledStrategyIds.build();
    }

    @Nonnull
    public String getDefaultStrategyId() {
        return this.defaultStrategyId;
    }

    @Nonnull
    public Set<String> getEnabledStrategyIds() {
        return this.enabledStrategyIds;
    }

    public static class Builder
    extends AbstractPullRequestMergeConfigRequest.AbstractBuilder<Builder, SetPullRequestMergeConfigRequest> {
        private final ImmutableSet.Builder<String> enabledStrategyIds = ImmutableSet.builder();
        private String defaultStrategyId;

        public Builder(@Nonnull Project project, @Nonnull String scmId) {
            super(project, scmId);
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull String scmId) {
            super(scmId);
        }

        @Override
        @Nonnull
        public SetPullRequestMergeConfigRequest build() {
            if (this.defaultStrategyId == null) {
                throw new IllegalStateException("The default strategy ID is required.");
            }
            return new SetPullRequestMergeConfigRequest(this);
        }

        @Nonnull
        public Builder defaultStrategyId(@Nonnull String value) {
            this.defaultStrategyId = Builder.requireNonBlank(value, "defaultStrategyId");
            return this.self();
        }

        @Nonnull
        public Builder enabledStrategyId(@Nonnull String value) {
            this.enabledStrategyIds.add((Object)Builder.requireNonBlank(value, "enabledStrategyId"));
            return this.self();
        }

        @Nonnull
        public Builder enabledStrategyIds(@Nonnull Iterable<String> values) {
            Objects.requireNonNull(values, "enabledStrategyIds");
            values.forEach(this::enabledStrategyId);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

