/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.server;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.server.ApplicationConfigurationChangedEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.server.time.zone.changed")
public class ServerTimeZoneChangedEvent
extends ApplicationConfigurationChangedEvent<String> {
    private final Long offset;

    public ServerTimeZoneChangedEvent(@Nonnull Object source, @Nullable String oldValue, @Nullable String newValue) {
        super(source, ApplicationConfigurationChangedEvent.Property.TIME_ZONE, oldValue, newValue);
        this.offset = ServerTimeZoneChangedEvent.getOffsetInMinutes(newValue);
    }

    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    @Nullable
    private static Long getOffsetInMinutes(String zoneId) {
        if (zoneId != null) {
            return TimeUnit.SECONDS.toMinutes(LocalDateTime.now().atZone(ZoneId.of(zoneId)).getOffset().getTotalSeconds());
        }
        return null;
    }
}

