/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import java.util.Objects;
import javax.annotation.Nonnull;

public class CommentUpdateRequest {
    private final long commentId;
    private final String text;
    private final int version;

    private CommentUpdateRequest(@Nonnull Builder builder) {
        this.commentId = builder.commentId;
        this.text = Objects.requireNonNull(builder.text, "text");
        this.version = builder.version;
    }

    public long getCommentId() {
        return this.commentId;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder {
        private final long commentId;
        private String text;
        private int version;

        public Builder(long commentId) {
            this.commentId = commentId;
        }

        @Nonnull
        public CommentUpdateRequest build() {
            return new CommentUpdateRequest(this);
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            this.text = value;
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this;
        }
    }
}

