/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleRefChange
implements RefChange {
    private final MinimalRef ref;
    private final String fromHash;
    private final String toHash;
    private final RefChangeType type;

    protected SimpleRefChange(@Nonnull AbstractBuilder<?> builder) {
        this.fromHash = ((AbstractBuilder)builder).fromHash;
        this.ref = ((AbstractBuilder)builder).ref;
        this.toHash = ((AbstractBuilder)builder).toHash;
        this.type = ((AbstractBuilder)builder).type;
    }

    @Deprecated
    protected SimpleRefChange(@Nonnull MinimalRef ref, @Nonnull String fromHash, @Nonnull String toHash, @Nonnull RefChangeType type) {
        this.fromHash = fromHash;
        this.ref = ref;
        this.toHash = toHash;
        this.type = type;
    }

    @Override
    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Override
    @Nonnull
    public MinimalRef getRef() {
        return this.ref;
    }

    @Override
    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Override
    @Nonnull
    public RefChangeType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleRefChange) {
            SimpleRefChange that = (SimpleRefChange)o;
            return this.fromHash.equals(that.fromHash) && Objects.equals(this.ref.getId(), that.ref.getId()) && Objects.equals(this.ref.getType(), that.ref.getType()) && this.toHash.equals(that.toHash) && this.type.equals((Object)that.type);
        }
        return false;
    }

    public int hashCode() {
        int result = this.ref.getId().hashCode();
        result = 31 * result + this.fromHash.hashCode();
        result = 31 * result + this.toHash.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.getRef().getId() + ": " + this.getFromHash() + " -> " + this.getToHash() + " (" + (Object)((Object)this.getType()) + ")";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private String fromHash;
        private MinimalRef ref;
        private String toHash;
        private RefChangeType type;

        protected AbstractBuilder() {
        }

        public AbstractBuilder(@Nonnull RefChange change) {
            this.fromHash = Objects.requireNonNull(change, "change").getFromHash();
            this.ref = change.getRef();
            this.toHash = change.getToHash();
            this.type = change.getType();
        }

        @Nonnull
        public B from(@Nonnull Ref value) {
            this.fromHash = Objects.requireNonNull(value, "ref").getLatestCommit();
            return this.ref(value);
        }

        @Nonnull
        public B fromHash(@Nonnull String value) {
            this.fromHash = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Nonnull
        public B ref(@Nonnull MinimalRef value) {
            this.ref = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Nonnull
        public B to(@Nonnull Ref value) {
            this.toHash = Objects.requireNonNull(value, "ref").getLatestCommit();
            return this.ref(value);
        }

        @Nonnull
        public B toHash(@Nonnull String value) {
            this.toHash = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Nonnull
        public B type(@Nonnull RefChangeType value) {
            this.type = Objects.requireNonNull(value, "value");
            return this.self();
        }

        protected void validate() {
            Objects.requireNonNull(this.fromHash, "fromHash");
            Objects.requireNonNull(this.ref, "ref");
            Objects.requireNonNull(this.toHash, "toHash");
            Objects.requireNonNull(this.type, "type");
        }

        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder() {
        }

        public Builder(@Nonnull RefChange refChange) {
            super(refChange);
        }

        @Nonnull
        public SimpleRefChange build() {
            this.validate();
            return new SimpleRefChange(this.self());
        }

        @Override
        @Nonnull
        public Builder from(@Nonnull Ref value) {
            return (Builder)super.from(value);
        }

        @Override
        @Nonnull
        public Builder fromHash(@Nonnull String value) {
            return (Builder)super.fromHash(value);
        }

        @Override
        @Nonnull
        public Builder ref(@Nonnull MinimalRef value) {
            return (Builder)super.ref(value);
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        @Nonnull
        public Builder to(@Nonnull Ref value) {
            return (Builder)super.to(value);
        }

        @Override
        @Nonnull
        public Builder toHash(@Nonnull String value) {
            return (Builder)super.toHash(value);
        }

        @Override
        @Nonnull
        public Builder type(@Nonnull RefChangeType value) {
            return (Builder)super.type(value);
        }
    }
}

