/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.job;

import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JobMessageCreationRequest {
    private final Job job;
    private final JobMessageSeverity severity;
    private final String subject;
    private final String text;

    private JobMessageCreationRequest(Builder builder) {
        this.job = Objects.requireNonNull(builder.job, "job");
        this.severity = builder.severity;
        this.subject = builder.subject;
        this.text = Objects.requireNonNull(builder.text, "text");
    }

    @Nonnull
    public Job getJob() {
        return this.job;
    }

    @Nonnull
    public JobMessageSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobMessageCreationRequest that = (JobMessageCreationRequest)o;
        return com.google.common.base.Objects.equal((Object)this.getJob().getId(), (Object)that.getJob().getId()) && com.google.common.base.Objects.equal((Object)((Object)this.getSeverity()), (Object)((Object)that.getSeverity())) && com.google.common.base.Objects.equal(this.getSubject(), that.getSubject()) && com.google.common.base.Objects.equal((Object)this.getText(), (Object)that.getText());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getJob(), this.getSubject(), this.getSeverity(), this.getText()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("job.id", this.job.getId()).add("severity", (Object)this.severity).add("subject", (Object)this.subject).add("text", (Object)this.text).toString();
    }

    public static class Builder {
        public Job job;
        public JobMessageSeverity severity;
        public String subject;
        public String text;

        public Builder(@Nonnull Job job, @Nonnull String text) {
            this.job = Objects.requireNonNull(job, "job");
            this.text = Objects.requireNonNull(text, "text");
            this.severity = JobMessageSeverity.INFO;
        }

        @Nonnull
        public Builder severity(@Nonnull JobMessageSeverity value) {
            this.severity = Objects.requireNonNull(value, "severity");
            return this;
        }

        @Nonnull
        public Builder subject(@Nullable String value) {
            this.subject = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public JobMessageCreationRequest build() {
            return new JobMessageCreationRequest(this);
        }
    }
}

