/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbstractDiffCommandParameters
extends AbstractCommandParameters {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private static final int MIN_LINE_LENGTH = 100;
    private final int contextLines;
    private final int maxLineLength;
    private final int maxLines;
    private final Set<String> paths;
    private final DiffWhitespace whitespace;

    @Deprecated
    public AbstractDiffCommandParameters(int maxLineLength, int maxLines, int contextLines, DiffWhitespace whitespace, Set<String> paths) {
        this.contextLines = contextLines;
        this.maxLineLength = maxLineLength;
        this.maxLines = maxLines;
        this.paths = paths;
        this.whitespace = whitespace;
    }

    protected AbstractDiffCommandParameters(AbstractBuilder<?> builder) {
        this.contextLines = builder.contextLines;
        this.maxLineLength = Math.max(builder.maxLineLength, 100);
        this.maxLines = builder.maxLines;
        this.paths = builder.paths.build();
        this.whitespace = builder.whitespace;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    public boolean hasContextLines() {
        return this.contextLines != -1;
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    @Nonnull
    protected DiffContext toContext(@Nonnull DiffContext.Builder builder) {
        return Objects.requireNonNull(builder, "builder").contextLines(this.getContextLines()).maxLineLength(this.getMaxLineLength()).maxLines(this.getMaxLines()).whitespace(this.getWhitespace()).build();
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        @Deprecated
        protected final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        @Deprecated
        protected int contextLines = -1;
        @Deprecated
        protected int maxLineLength;
        @Deprecated
        protected int maxLines;
        @Deprecated
        protected DiffWhitespace whitespace = DiffWhitespace.SHOW;

        @Nonnull
        public B contextLines(int value) {
            this.contextLines = value;
            return this.self();
        }

        @Nonnull
        public B defaultContextLines() {
            this.contextLines = -1;
            return this.self();
        }

        @Nonnull
        public B maxLineLength(int value) {
            this.maxLineLength = value;
            return this.self();
        }

        @Nonnull
        public B maxLines(int value) {
            this.maxLines = value;
            return this.self();
        }

        @Nonnull
        public B path(@Nullable String value) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable Iterable<String> values) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable String value, String ... values) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        @Nonnull
        public B whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "whitespace");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

