package com.atlassian.bitbucket.util;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * A simple implementation of the {@link NamedLink} interface.
 */
public class SimpleNamedLink implements NamedLink {

    private final String href;
    private final String name;

    public SimpleNamedLink(@Nonnull String href, @Nonnull String name) {
        checkNotNull(isNotBlank(href), "href must be supplied");
        checkArgument(isNotBlank(name), "name must be supplied");

        this.href = href;
        this.name = name;
    }

    @Nonnull
    @Override
    public String getHref() {
        return href;
    }

    @Nonnull
    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SimpleNamedLink that = (SimpleNamedLink) o;

        return name.equals(that.name) && href.equals(that.href);
    }

    @Override
    public int hashCode() {
        int result = href.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SimpleNamedLink{" +
                "href='" + href + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
