package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Indicates the named user does not exist
 */
public class NoSuchUserException extends NoSuchEntityException {

    private final String username;

    public NoSuchUserException(@Nonnull KeyedMessage message, @Nonnull String username) {
        super(message);

        this.username = checkNotNull(username, "username");
    }

    @Nonnull
    public String getUsername() {
        return username;
    }
}
