package com.atlassian.bitbucket.task;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown to indicate the task's {@link #getState() state} does not allow performing the requested operation.
 */
public class IllegalTaskStateException extends IllegalEntityStateException {

    private final TaskState state;

    public IllegalTaskStateException(@Nonnull KeyedMessage message, @Nonnull TaskState state) {
        super(message);
        this.state = state;
    }

    @Nonnull
    public TaskState getState() {
        return state;
    }
}
