package com.atlassian.bitbucket.scm.signed;

import com.atlassian.bitbucket.scm.ScmExtendedCommandFactory;

import javax.annotation.Nonnull;

/**
 * Provides object IDs to the {@link ScmExtendedCommandFactory#signedObjects(SignedObjectsParameters, SignedObjectCallback)}
 * command to be resolved into signed objects.
 * <p>
 * Returned object IDs can either be commit IDs or ref IDs.
 *
 * @since 5.1
 */
public interface SignedObjectIdSource {

    /**
     * @return {@code true} if there are any more object IDs to be resolved.
     */
    boolean hasNext();

    /**
     * @return the next object ID
     * @throws java.util.NoSuchElementException if called when {@link #hasNext()} returns {@code false}
     */
    @Nonnull
    String next();
}
