package com.atlassian.bitbucket.scm.signed;

import com.atlassian.bitbucket.scm.ScmExtendedCommandFactory;

import javax.annotation.Nonnull;

/**
 * Describes a type of object that can be signed, or for which signed content can be
 * {@link ScmExtendedCommandFactory#signedObjects retrieved}.
 *
 * @see StandardSignableObjectType for the built-in supported types
 *
 * @since 5.1
 */
public interface SignableObjectType {

    /**
     * @return the identifier for the signable object type
     */
    @Nonnull
    String getId();
}
