package com.atlassian.bitbucket.scm.ref;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

public class AbstractCreateRefCommandParameters extends AbstractRefCommandParameters {

    private final String startPoint;

    protected AbstractCreateRefCommandParameters(AbstractCreateRefBuilder builder) {
        super(builder);

        startPoint = builder.startPoint;
    }

    /**
     * @return the commit the new ref will point to, which may be identified by ID or by branch or tag name
     */
    @Nonnull
    public String getStartPoint() {
        return startPoint;
    }

    public abstract static class AbstractCreateRefBuilder<B extends AbstractCreateRefBuilder<B>>
            extends AbstractRefBuilder<B> {

        private String startPoint;

        @Nonnull
        public B startPoint(@Nonnull String value) {
            startPoint = checkNotNull(value, "startPoint");

            return self();
        }

        @Override
        protected void validate() {
            super.validate();

            if (StringUtils.isBlank(startPoint)) {
                throw new IllegalStateException("When creating a ref a startPoint is required.");
            }
        }
    }
}
