package com.atlassian.bitbucket.scm.compare;

import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class CompareDiffCommandParameters extends AbstractDiffCommandParameters {

    private CompareDiffCommandParameters(Builder builder) {
        super(builder);
    }

    @Nonnull
    public DiffContext toContext(@Nonnull CompareRequest compareRequest, @Nonnull String mergeBase) {
        return toContext(new DiffContext.Builder(
                requireNonBlank(mergeBase, "mergeBase"),
                requireNonNull(compareRequest, "compareRequest").getFromRef().getId()));
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public CompareDiffCommandParameters build() {
            return new CompareDiffCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
