package com.atlassian.bitbucket.scm.bulk;

import javax.annotation.Nonnull;

/**
 * Metadata about a file of a bulk content command.
 *
 * @since 4.2
 */
public interface BulkFile {

    /**
     * @return how the file has changed
     */
    @Nonnull
    BulkChangeType getChangeType();

    /**
     * For {@link BulkChangeType#ADD added} or {@link BulkChangeType#MODIFY modified} files, returns a content ID for
     * the new content. For {@link BulkChangeType#DELETE deleted} files, the ID is for the content before deletion.
     *
     * @return an ID that identifies the contents of the file
     */
    @Nonnull
    String getContentId();

    /**
     * @return the file path
     */
    @Nonnull
    String getPath();

    /**
     * @return the file size in bytes, or {@code 0} for {@link BulkChangeType#DELETE deleted} files
     */
    long getSize();
}
