package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

public class MergeException extends ScmException {

    private final boolean conflicted;
    private final String from;
    private final Repository repository;
    private final String to;

    /**
     * @since 5.0
     */
    public MergeException(@Nonnull KeyedMessage message, @Nonnull String scmId,
                          @Nonnull Repository repository, @Nonnull String from, @Nonnull String to,
                          boolean conflicted) {
        this(message, null, scmId, repository, from, to, conflicted);
    }

    /**
     * @deprecated since 5.0 for removal in 6.0.
     *             Use {@link #MergeException(KeyedMessage, String, Repository, String, String, boolean)} instead
     */
    @Deprecated
    public MergeException(@Nonnull KeyedMessage message, @Nonnull String scmId,
                          @Nonnull Repository repository, @Nonnull String from, @Nonnull String to) {
        this(message, null, scmId, repository, from, to, false);
    }

    /**
     * @deprecated since 5.0 for removal in 6.0. Use
     *             {@link #MergeException(KeyedMessage, Throwable, String, Repository, String, String, boolean)} instead
     */
    @Deprecated
    public MergeException(@Nonnull KeyedMessage message, @Nullable Throwable cause, @Nonnull String scmId,
                          @Nonnull Repository repository, @Nonnull String from, @Nonnull String to) {
        this(message, cause, scmId, repository, from, to, false);
    }

    /**
     * @since 5.0
     */
    public MergeException(@Nonnull KeyedMessage message, @Nullable Throwable cause, @Nonnull String scmId,
                          @Nonnull Repository repository, @Nonnull String from, @Nonnull String to,
                          boolean conflicted) {
        super(message, cause, scmId);

        this.conflicted = conflicted;
        this.repository = checkNotNull(repository, "repository");
        this.from = checkNotNull(from, "from");
        this.to = checkNotNull(to, "to");
    }

    @Nonnull
    public String getFrom() {
        return from;
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }

    @Nonnull
    public String getTo() {
        return to;
    }

    /**
     * @return {@code true} if the merge failed because the resulting merge had conflicts
     * @since 5.0
     */
    public boolean isConflicted() {
        return conflicted;
    }
}
