package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Thrown to indicate a requested SCM feature, such as {@link ScmFeature#COMMAND_BUILDERS command builders} or
 * {@link ScmFeature#PULL_REQUESTS pull requests}, is not supported by the backing SCM implementation.
 */
public class FeatureUnsupportedScmException extends ScmException {

    private final ScmFeature feature;

    public FeatureUnsupportedScmException(@Nonnull KeyedMessage message, @Nonnull String scmId,
                                          @Nonnull ScmFeature feature) {
        super(message, scmId);

        this.feature = checkNotNull(feature, "feature");
    }

    /**
     * The feature which was requested but is not supported.
     *
     * @return the requested, unsupported feature
     */
    @Nonnull
    public ScmFeature getFeature() {
        return feature;
    }
}
