package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.AbstractRepositoryRefsRequest;
import com.atlassian.bitbucket.repository.RefOrder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

@SuppressWarnings({"deprecation", "DeprecatedIsStillUsed"})
public abstract class AbstractRefsCommandParameters extends AbstractCommandParameters {

    /**
     * @deprecated in 5.1. This field will be made private in 6.0. Use {@link #getFilterText()} instead.
     */
    @Deprecated
    protected final String filterText;
    /**
     * @deprecated in 5.1. This field will be made private in 6.0. Use {@link #getOrder()} instead.
     */
    @Deprecated
    protected final RefOrder order;

    /**
     * @param builder the builder to extract parameters from
     * @since 5.1
     */
    protected AbstractRefsCommandParameters(AbstractBuilder<?> builder) {
        filterText = builder.filterText;
        order = builder.order;
    }

    /**
     * @param order      the order refs should be returned in, or {@code null} to use a default order
     * @param filterText the filter to apply to ref names; or {@code null} to return all refs
     * @deprecated in 5.1 for removal in 6.0. Use {@link #AbstractRefsCommandParameters(AbstractBuilder)} instead.
     */
    @Deprecated
    protected AbstractRefsCommandParameters(RefOrder order, String filterText) {
        this.order = order;
        this.filterText = filterText;
    }

    @Nullable
    public String getFilterText() {
        return filterText;
    }

    @Nullable
    public RefOrder getOrder() {
        return order;
    }

    public abstract static class AbstractBuilder<B extends AbstractBuilder<B>> {

        /**
         * @deprecated in 5.1. This field will be made private in 6.0.
         */
        @Deprecated
        protected String filterText;
        /**
         * @deprecated in 5.1. This field will be made private in 6.0.
         */
        @Deprecated
        protected RefOrder order;

        public AbstractBuilder() {
        }

        /**
         * @param request the request to copy parameters from
         * @since 5.1
         */
        public AbstractBuilder(@Nonnull AbstractRepositoryRefsRequest request) {
            requireNonNull(request, "request");

            filterText(request.getFilterText())
                    .order(request.getOrder());
        }

        @Nonnull
        public B filterText(@Nullable String value) {
            filterText = value;

            return self();
        }

        @Nonnull
        public B order(@Nullable RefOrder value) {
            order = value;

            return self();
        }

        @Nonnull
        protected abstract B self();
    }
}
