package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * A request for tags within a repository. The purpose and behaviour of each field is described on its accessor.
 */
public class RepositoryTagsRequest extends AbstractRepositoryRefsRequest {

    private RepositoryTagsRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, RepositoryTagsRequest> {

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        @Nonnull
        @Override
        public RepositoryTagsRequest build() {
            return new RepositoryTagsRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
