package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;

import javax.annotation.Nonnull;

/**
 * Represents a ref change, used mainly by {@link RepositoryRefsChangedEvent}.
 */
public interface RefChange {

    /**
     * The maximum length of a ref change's to and from hash
     * @since 4.11
     */
    int MAX_HASH_LENGTH = 40;

    /**
     * @return the ref that has been updated
     */
    @Nonnull
    MinimalRef getRef();

    /**
     * @return the previous hash
     */
    @Nonnull
    String getFromHash();

    /**
     * @return the new hash
     */
    @Nonnull
    String getToHash();

    /**
     * @return the type of ref change
     */
    @Nonnull
    RefChangeType getType();
}
