package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Thrown to indicate the configured default branch for a repository does not exist.
 */
public class NoDefaultBranchException extends NoSuchEntityException {

    private final String branchName;
    private final String repositoryName;

    public NoDefaultBranchException(@Nonnull KeyedMessage message, @Nonnull String repositoryName, @Nullable String branchName) {
        super(message);

        this.branchName = branchName;
        this.repositoryName = checkNotNull(repositoryName, "repositoryName");
    }

    /**
     * Retrieves the name of the branch which is configured as the default branch in the repository.
     *
     * @return the branch name or {@code null} if unknown
     */
    @Nullable
    public String getBranchName() {
        return branchName;
    }

    /**
     * Retrieves the name of the repository whose default branch does not exist.
     *
     * @return the repository name
     */
    @Nonnull
    public String getRepositoryName() {
        return repositoryName;
    }
}
