package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Thrown to indicate an operation could not be completed because the {@link Repository repository} was not in the
 * expected {@link Repository.State state}. For example, attempting to retry creating a repository might throw this
 * exception if the repository was already created successfully.
 */
public class IllegalRepositoryStateException extends IllegalEntityStateException {

    public IllegalRepositoryStateException(KeyedMessage message) {
        super(message);
    }
}
