package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * A request to create a {@link com.atlassian.bitbucket.repository.Tag tag}.
 */
public class CreateTagRequest extends AbstractCreateRefRequest {

    public CreateTagRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, CreateTagRequest> {

        public Builder(@Nonnull Repository repository, @Nonnull String name, @Nonnull String startPoint) {
            super(repository, name, startPoint);
        }

        @Nonnull
        public CreateTagRequest build() {
            return new CreateTagRequest(this);
        }

        @Nonnull
        @Override
        public Builder self() {
            return this;
        }
    }
}
