package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.property.PropertySupport;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * Describes whether a pull request can merge and why this is so.
 */
public interface PullRequestMergeability extends PropertySupport {

    /**
     * @return {@code false} if the pull request cannot be merged for any reason; otherwise {@code true}
     */
    boolean canMerge();

    /**
     * @return the {@link PullRequestMergeOutcome outcome} of trying to merge this pull request
     * @since 4.10
     */
    @Nonnull
    PullRequestMergeOutcome getOutcome();

    /**
     * @return a collection containing zero or more {@link PullRequestMergeVeto vetoes} from {@code MergeRequestCheck}s
     *         used to validate merge preconditions
     */
    @Nonnull
    Collection<PullRequestMergeVeto> getVetoes();

    /**
     * @return {@code true} if the {@link #getOutcome() outcome} is {@link PullRequestMergeOutcome#CONFLICTED}; {@code false} otherwise
     */
    boolean isConflicted();
}
