package com.atlassian.bitbucket.pull;

/**
 * Specified the direction of a pull request relative to a subject repository and branch.
 */
public enum PullRequestDirection {

    /**
     * OUTGOING indicates the pull request is coming from the repository and branch in question.
     */
    OUTGOING,

    /**
     *  INCOMING indicates the pull request is going to the repository and branch in question.
     */
    INCOMING;

    /**
     * @return the opposite direction to the current direction
     */
    public PullRequestDirection opposite() {
        return this == OUTGOING ? INCOMING : OUTGOING;
    }
}
