package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.event.pull.PullRequestDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Thrown when an event listener cancels the {@link PullRequestDeletionRequestedEvent event} raised before a
 * {@link PullRequest pull request} is deleted.
 *
 * @see PullRequestService#delete(PullRequestDeleteRequest)
 * @since 5.1
 */
public class PullRequestDeletionCanceledException extends RequestCanceledException {

    public PullRequestDeletionCanceledException(@Nonnull KeyedMessage message,
                                                @Nonnull List<KeyedMessage> cancelMessages) {
        super(message, cancelMessages);
    }
}
