package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.util.Page;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collection;

/**
 * @since 4.8
 */
public interface PullRequestCommitEnricher {

    /**
     * Enrich a single commit with properties from the {@link CommitIndex}.
     *
     * @param pullRequest  the pull request the {@link Commit commit} was retrieved from
     * @param commit       the commit to enrich
     * @param propertyKeys keys for {@link CommitIndex CommitIndex} properties to load
     * @return the enriched commit
     */
    @Nonnull
    Commit enrich(@Nonnull PullRequest pullRequest, @Nonnull Commit commit, @Nullable Collection<String> propertyKeys);

    /**
     * Enrich a page of commits with properties from the {@link CommitIndex}.
     *
     * @param pullRequest  the pull request the {@link Commit commits} were retrieved from
     * @param page         the page of commits to enrich
     * @param propertyKeys keys for {@link CommitIndex CommitIndex} properties to load
     * @return a page of enriched commits
     */
    @Nonnull
    Page<Commit> enrichPage(@Nonnull PullRequest pullRequest, @Nonnull Page<Commit> page,
                            @Nullable Collection<String> propertyKeys);
}
