package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.util.Page;

/**
 * A {@link Page} of {@link PullRequestActivity activities} allowing clients to both advance
 * and reverse from this page by using the results of {@link PullRequestActivityPage#getPreviousPageStartId()}
 * and {@link #getNextPageRequest()}.
 */
public interface PullRequestActivityPage<T extends PullRequestActivity> extends Page<T> {

    long NO_ID = -1;

    /**
     * @return true if this is the first page of results
     */
    boolean getIsFirstPage();

    /**
     * @return the ID of the activity of previous page of results or {@link #NO_ID} if this is the first page
     */
    long getPreviousPageStartId();
}
