package com.atlassian.bitbucket.migration.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.migration.ExportRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when an Data Center Migration export has been started.
 *
 * @since 5.13
 */
@AsynchronousPreferred
@EventName("stash.migration.export.start")
public class MigrationExportStartedEvent extends AbstractInstanceMigrationEvent {

    private final ExportRequest request;

    public MigrationExportStartedEvent(@Nonnull Object source, Job job, @Nonnull ExportRequest request) {
        super(source, job);
        this.request = request;
    }

    /**
     * @return the number of selectors that specify a project with all of its repositories
     */
    public long getEntireProjectSelectedCount() {
        return request.getRepositoriesRequest().getIncludes()
                .stream()
                .filter(s -> "*".equals(s.getSlug()))
                .count();
    }

    /**
     * @return {@code true} if all project <b> AND </b> all repositories have been selected for export
     */
    public boolean getSelectAll() {
        return request.getRepositoriesRequest().getIncludes()
                .stream()
                .anyMatch(s -> "*".equals(s.getProjectKey()) && "*".equals(s.getSlug()));
    }

    /**
     * @return the number of project/repository tuples selected for export
     */
    public int getSelectorCount() {
        return request.getRepositoriesRequest().getIncludes().size();
    }
}
