package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 * Runtime exception generated during a migration of repositories.
 *
 * @since 5.13
 */
public abstract class MigrationException extends ServiceException {

    private final Object subject;

    protected MigrationException(@Nonnull KeyedMessage message, @Nullable Object subject, @Nullable Throwable cause) {
        super(message, cause);

        this.subject = subject;
    }

    /**
     * @return advisory information on the (possibly null) subject of the import or export at the time the exception was
     * thrown. This is typically the {@link Repository}, {@link Project} or {@link PullRequest} being exported or
     * imported but may be any other type of object that is deemed appropriate. If the exception prevented the creation
     * of the subject itself so an instance is not available to pass in to this exception then the most relevant
     * containing entity or object is appropriate. If the subject was not known or the exception is not specifically
     * tied to any one subject (e.g. an IO exception while reading the export archive for import) then a null subject
     * is appropriate.
     */
    @Nonnull
    public Optional<Object> getSubject() {
        return ofNullable(subject);
    }
}
