package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Base class for mail exceptions.
 *
 * Instance of this exception will be logged to the mail log along with details of the mail message being sent.
 * It is at the discretion of the caller whether these should be logged elsewhere.
 */
public class MailException extends ServiceException {

    public MailException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public MailException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
