package com.atlassian.bitbucket.mail;

import javax.annotation.Nonnull;

/**
 * HtmlCssInliner inlines CSS from plugin modules into HTML.
 */
public interface HtmlCssInliner {

    /**
     * Inline CSS referred to by the given complete module key into a given String of HTML.
     * This will include any CSS resource descriptors referred to in the module's dependency tree.
     *
     * @param html HTML to perform CSS inlining on
     * @param cssModuleKey Complete module key for plugin module that has CSS script resources and/or dependencies
     * @return HTML with CSS inlined.
     */
    @Nonnull
    String inlineCss(@Nonnull String html, @Nonnull String cssModuleKey);
}
