package com.atlassian.bitbucket.label;

import javax.annotation.Nonnull;

/**
 * @since 5.12
 */
public interface Labelable {

    /**
     * Accepts the provided {@link LabelableVisitor visitor} and invokes the appropriate {@code visit} overload
     * for this labelable type, returning its result.
     * <p>
     * Note: Nullability for the return value is intentionally not documented one way or another. It is expected that
     * the <i>caller</i> will know the nullability of the visitor implementation they are passing and code accordingly.
     *
     * @param visitor the visitor to invoke
     * @return the result of the invoked {@code visit} method
     */
    <T> T accept(@Nonnull LabelableVisitor<T> visitor);
}
