package com.atlassian.bitbucket.jira;

/**
 * Used to indicate something has gone wrong with the creation of the Jira Application Link and/or creation of the Jira
 * Crowd configuration.
 */
public class JiraSetupException extends RuntimeException {

    /**
     * @param prettyUserMessage a message for display in the UI that will contain a brief description of the problem
     * and the next steps the user should take.
     */
    public JiraSetupException(final String prettyUserMessage) {
        super(prettyUserMessage);
    }

    /**
     * @param prettyUserMessage a message for display in the UI that will contain a brief description of the problem
     * and the next steps the user should take.
     * @param cause the nested exception that is or contains the root cause of the problem
     */
    public JiraSetupException(final String prettyUserMessage, final Throwable cause) {
        super(prettyUserMessage, cause);
    }
}
