package com.atlassian.bitbucket.idx;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Locale;

/**
 * A request to search the index.
 *
 * @see CommitIndex#search(IndexSearchRequest, PageRequest)
 */
public class IndexSearchRequest {

    private final String filter;

    private IndexSearchRequest(Builder builder) {
        this.filter = builder.filter;
    }

    /**
     * @return the filter criterion. If {@code null} is returned no filter will be applied to the search.
     */
    @Nullable
    public String getFilter() {
        return filter;
    }

    @Override
    public String toString() {
        return "IndexSearchRequest{" +
                "filter='" + filter + '\'' +
                '}';
    }

    public static class Builder extends BuilderSupport {

        private String filter;

        public Builder() {
        }

        @Nonnull
        public IndexSearchRequest build() {
            return new IndexSearchRequest(this);
        }

        @Nonnull
        public Builder prefix(@Nonnull String value) {
            filter = checkNotBlank(value, "filter").trim().toLowerCase(Locale.ROOT);

            return this;
        }
    }
}
