package com.atlassian.bitbucket.i18n;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A container object to allow the passing of a property key and its associated context variables.
 * This allows a property to be expanded just-in-time.
 */
public class I18nKey {

    private final Object[] arguments;
    private final String key;

    public I18nKey(@Nonnull String key, @Nonnull Object... arguments) {
        this.key = checkNotNull(key, "key");
        this.arguments = checkNotNull(arguments, "context");
    }

    @Nonnull
    public Object[] getArguments() {
        return arguments;
    }

    @Nonnull
    public String getKey() {
        return key;
    }
}
