package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * A {@link RepositoryHookRequest hook request} that is raised when an SCM client pushes to the repository.
 *
 * @see StandardRepositoryHookTrigger#REPO_PUSH
 * @since 5.0
 */
public class RepositoryPushHookRequest extends SimpleRepositoryHookRequest {

    private RepositoryPushHookRequest(AbstractBuilder<?> builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder(@Nonnull Repository repository) {
            super(repository, StandardRepositoryHookTrigger.REPO_PUSH);
        }

        @Nonnull
        public RepositoryPushHookRequest build() {
            return new RepositoryPushHookRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
