package com.atlassian.bitbucket.hook.repository;

import javax.annotation.Nonnull;

/**
 * Describes the reasons for rejecting a {@link RepositoryHookRequest}
 *
 * @see RepositoryHookService#preUpdate(RepositoryHookRequest)
 * @since 5.0
 */
public interface RepositoryHookVeto {

    /**
     * @return a detailed description of the reason for rejecting the request
     */
    @Nonnull
    String getDetailedMessage();

    /**
     * @return a short summary of describing why the request was rejected
     */
    @Nonnull
    String getSummaryMessage();
}
