package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

/**
 * Request object used for {@link RepositoryHookService#disable(DisableRepositoryHookRequest) disabling a repository hook}.
 *
 * @since 5.2
 */
public class DisableRepositoryHookRequest extends AbstractUpdateRepositoryHookRequest {

    private DisableRepositoryHookRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder {

        public Builder(@Nonnull Scope scope, @Nonnull String hookKey) {
            super(scope, hookKey);
        }

        @Nonnull
        public DisableRepositoryHookRequest build() {
            return new DisableRepositoryHookRequest(this);
        }
    }
}
