package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

/**
 * Request object used to {@link RepositoryHookService#delete(DeleteRepositoryHookRequest) delete repository hook configuration}.
 *
 * @since 5.2
 */
public class DeleteRepositoryHookRequest extends AbstractUpdateRepositoryHookRequest {

    private DeleteRepositoryHookRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder {

        public Builder(@Nonnull Scope scope, @Nonnull String hookKey) {
            super(scope, hookKey);
        }

        @Nonnull
        public DeleteRepositoryHookRequest build() {
            return new DeleteRepositoryHookRequest(this);
        }
    }
}