package com.atlassian.bitbucket.event.user;

import com.atlassian.bitbucket.event.ApplicationEvent;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Raised when a group is deleted from all user directories visible to the server.
 * <p>
 * Clients that store data used to <em>authorize</em> a group should subscribe to this event to clean up data related to the
 * deleted group. For example, if a plugin allocates resource permissions to groups, it should listen for this event
 * and delete those permissions.
 */
public class GroupCleanupEvent extends ApplicationEvent {

    private final String group;

    public GroupCleanupEvent(@Nonnull Object source, @Nonnull String group) {
        super(source);
        this.group = checkNotNull(group, "group");
    }

    @Nonnull
    public String getGroup() {
        return group;
    }

}
