package com.atlassian.bitbucket.event.task;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a task is created.
 */
@AsynchronousPreferred
@EventName("stash.task.created")
public class TaskCreatedEvent extends TaskEvent {

    public TaskCreatedEvent(@Nonnull Object source, @Nonnull Task task) {
        super(source, task);
    }

}
