package com.atlassian.bitbucket.event.tag;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;

/**
 * An event that is raised just before a tag is deleted using the UI or REST.
 * Tags deleted by pushing will not trigger this event.
 * <p>
 * This event is {@link CancelableEvent cancelable}. A listener may prevent the tag
 * from being deleted by {@link #cancel(KeyedMessage) canceling} this event. Throwing an
 * exception <i>will not</i> prevent the tag from being deleted; the exception will be logged and ignored.
 *
 * @deprecated in 5.0 for removal in 6.0. Listeners for {@code TagDeletionRequestEvent} or one of its subclasses
 *             should implement a {@code PreRepositoryHook} and check the
 *             {@link com.atlassian.bitbucket.hook.repository.RepositoryHookRequest request} for the
 *             {@link com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger#TAG_DELETE} trigger
 */
@Deprecated
public class TagDeletionRequestedEvent extends TagChangeRequestedEvent {

    public TagDeletionRequestedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                     @Nonnull Tag tag, @Nonnull CancelState cancelState) {
        super(source, repository, cancelState, tag);
    }
}
