package com.atlassian.bitbucket.event.server;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;

@AsynchronousPreferred
@EventName("stash.server.time.zone.changed")
public class ServerTimeZoneChangedEvent extends ApplicationConfigurationChangedEvent<String> {

    private final Long offset;

    public ServerTimeZoneChangedEvent(@Nonnull Object source, @Nullable String oldValue, @Nullable String newValue) {
        super(source, Property.TIME_ZONE, oldValue, newValue);
        offset = getOffsetInMinutes(newValue);
    }

    @Nullable
    public Long getOffset() {
        return offset;
    }

    @Nullable
    private static Long getOffsetInMinutes(String zoneId) {
        if (zoneId != null) {
            return TimeUnit.SECONDS.toMinutes(LocalDateTime.now().atZone(ZoneId.of(zoneId)).getOffset().getTotalSeconds());
        } else {
            return null;
        }
    }
}
