package com.atlassian.bitbucket.event.server;

import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when the server email address is changed.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
@AsynchronousPreferred
public class ServerEmailAddressChangedEvent extends ApplicationConfigurationChangedEvent<String> {

    public ServerEmailAddressChangedEvent(@Nonnull Object source, @Nullable String oldValue, @Nullable String newValue) {
        super(source, Property.SERVER_EMAIL_ADDRESS, oldValue, newValue);
    }
}
