package com.atlassian.bitbucket.event.server;

import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when the mail host configuration is changed.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
@AsynchronousPreferred
public class MailHostConfigurationChangedEvent extends ApplicationConfigurationChangedEvent<MailHostConfiguration> {

    public MailHostConfigurationChangedEvent(@Nonnull Object source, @Nullable MailHostConfiguration oldValue, @Nullable MailHostConfiguration newValue) {
        super(source, Property.MAIL_HOST_CONFIGURATION, oldValue, newValue);
    }
}
